Imports System.IO
Imports System.drawing
Imports System.Windows.Forms

Module Module1
    Sub Main()
        Console.WriteLine("Cration d'un fichier et criture de donnes binaires...")
        ' Ouverture d'un fichier bitmap.
        Dim myFStream As FileStream _
            = New FileStream("temp.dat", _
            FileMode.OpenOrCreate, _
            FileAccess.ReadWrite)

        ' Ecriture d'informations binaires.
        Dim binWrit As BinaryWriter = New BinaryWriter(myFStream)
        binWrit.Write("Bonjour sous forme d'informations binaires...")

        Dim myInt As Integer = 99
        Dim myDouble As Double = 9984.823
        Dim myBool As Boolean = False
        Dim myCharArray() As Char = {"B", "o", "n", "j", "o", "u", "r"}
        binWrit.Write(myInt)
        binWrit.Write(myDouble)
        binWrit.Write(myBool)
        binWrit.Write(myCharArray)

        ' Remise  zro de la position interne.
        binWrit.BaseStream.Position = 0

        ' Lecture des donnes binaires comme des octet rangs.
        Console.WriteLine("Lecture des donnes binaires...")
        Dim binRead As BinaryReader = New BinaryReader(myFStream)
        Dim temp As Integer

        Dim input As String
        Do
            Console.Write(binRead.ReadByte())
            temp = temp + 1
            If (temp = 5) Then
                temp = 0
                Console.WriteLine()
            End If
        Loop While (binRead.PeekChar() <> -1)

        ' Tout nettoyer.
        Console.WriteLine()
        binWrit.Close()
        binRead.Close()
        myFStream.Close()

        'Construction d'un Bitmap bas sur un stream.
        Console.WriteLine("Modification d'un bitmap en mmoire")
        myFStream = New FileStream("Paint Splatter.bmp", _
                FileMode.Open, _
                FileAccess.ReadWrite)
        Dim rawBitmap As Bitmap = New Bitmap(myFStream)

        ' Dessiner un 'X' blanc sur l'image. 
        ' (La logique suivante par du principe que la hauteur et la largeur de l'image sont identiques.)
        Dim i As Integer
        For i = 0 To rawBitmap.Width - 1
            rawBitmap.SetPixel(i, i, Color.White)
            rawBitmap.SetPixel((rawBitmap.Width - i) - 1, _
                      i - 1, Color.White)
        Next
        ' Maintenant sauver l'image modifie dans un fichier.
        Console.WriteLine("Sauvegarde de l'image modifie dans un fichier")
        rawBitmap.Save("newImage.bmp")
        myFStream.Close()
    End Sub
End Module
